/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.registry;

import dev.quantumfusion.dashloader.DashObjectClass;
import dev.quantumfusion.dashloader.Dashable;
import dev.quantumfusion.dashloader.registry.ChunkHolder;
import dev.quantumfusion.dashloader.registry.RegistryReader;
import dev.quantumfusion.dashloader.registry.RegistryWriter;
import dev.quantumfusion.dashloader.registry.chunk.data.AbstractDataChunk;
import dev.quantumfusion.dashloader.registry.chunk.write.AbstractWriteChunk;
import dev.quantumfusion.dashloader.registry.chunk.write.FloatingWriteChunk;
import dev.quantumfusion.dashloader.registry.chunk.write.StagedWriteChunk;
import dev.quantumfusion.dashloader.registry.chunk.write.WriteChunk;
import dev.quantumfusion.dashloader.registry.factory.DashFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public final class RegistryHandler {
    /*
     * WARNING - void declaration
     */
    private static <O> List<O> calculateBuildOrder(List<Holder<O>> elements) {
        void var4_9;
        int elementsSize = elements.size();
        HashMap mapping = new HashMap();
        for (Holder<O> holder : elements) {
            mapping.put(holder.self, holder);
        }
        for (Holder<O> holder : elements) {
            for (Class<?> dependency : holder.dependencies) {
                ++((Holder)mapping.get(dependency)).references;
            }
        }
        ArrayDeque<Holder> queue = new ArrayDeque<Holder>(elementsSize);
        for (Holder<O> holder : elements) {
            if (((Holder)mapping.get(holder.self)).references != 0) continue;
            queue.offer(holder);
        }
        boolean bl = false;
        Holder[] holderArray = new Holder[elementsSize];
        while (!queue.isEmpty()) {
            Holder element = (Holder)queue.poll();
            holderArray[++var4_9] = element;
            for (Class clazz : element.dependencies) {
                if (--((Holder)mapping.get((Object)clazz)).references != 0) continue;
                queue.offer((Holder)mapping.get(clazz));
            }
        }
        if (var4_9 != elementsSize) {
            throw new IllegalArgumentException("Dependency overflow! Meaning it's https://www.youtube.com/watch?v=PGNiXGX2nLU.");
        }
        ArrayList out = new ArrayList(holderArray.length);
        for (Holder holder : holderArray) {
            out.add(0, holder.object);
        }
        return out;
    }

    public RegistryReader createReader(ChunkHolder ... holders) {
        ArrayList dataChunks = new ArrayList();
        for (ChunkHolder holder : holders) {
            Collections.addAll(dataChunks, holder.getChunks());
        }
        AbstractDataChunk[] out = new AbstractDataChunk[dataChunks.size()];
        Iterator iterator = dataChunks.iterator();
        while (iterator.hasNext()) {
            AbstractDataChunk dataChunk;
            out[dataChunk.pos] = dataChunk = (AbstractDataChunk)iterator.next();
        }
        return new RegistryReader(out);
    }

    public <R, D extends Dashable<R>> RegistryWriter createWriter(Map<Class<?>, DashFactory.FailCallback<?, ?>> callbacks, Collection<DashObjectClass<?, ?>> dashObjects) {
        HashMap<Class, DashObjectGroup> groups = new HashMap<Class, DashObjectGroup>();
        Iterator<DashObjectClass<?, ?>> iterator = dashObjects.iterator();
        while (iterator.hasNext()) {
            DashObjectClass<?, ?> raw;
            DashObjectClass<?, ?> dashObject = raw = iterator.next();
            DashObjectGroup group = groups.computeIfAbsent(dashObject.getTag(), aClass -> new DashObjectGroup(dashObject.getTag()));
            group.addDashObject(dashObject);
        }
        List groupOrder = RegistryHandler.calculateBuildOrder(Holder.map(groups.values(), objectGroup -> {
            objectGroup.prepareForSort(groups);
            return new Holder<DashObjectGroup>(objectGroup.dashTag, (Collection<Class<?>>)objectGroup.dependencies, (DashObjectGroup)objectGroup);
        }));
        AbstractWriteChunk[] chunks = new AbstractWriteChunk[groupOrder.size()];
        RegistryWriter writer = new RegistryWriter(chunks);
        if (groupOrder.size() > 63) {
            throw new RuntimeException("Hit group limit of 63. Please contact QuantumFusion if you hit this limit!");
        }
        for (int i = 0; i < groupOrder.size(); ++i) {
            DashObjectGroup group = (DashObjectGroup)groupOrder.get(i);
            chunks[i] = group.createWriteChunk((byte)i, writer, callbacks);
            writer.addChunkMapping(group.dashTag, (byte)i);
        }
        writer.compileMappings();
        return writer;
    }

    private static class Holder<O> {
        public final O object;
        private final Class<?> self;
        private final Collection<Class<?>> dependencies;
        private int references = 0;

        public Holder(Class<?> self, Collection<Class<?>> dependencies, O object) {
            this.self = self;
            this.dependencies = dependencies;
            this.object = object;
        }

        public static <O> List<Holder<O>> map(Collection<O> objects, Function<O, Holder<O>> mapper) {
            ArrayList holders = new ArrayList();
            objects.forEach(object -> holders.add((Holder)mapper.apply(object)));
            return holders;
        }
    }

    private static final class DashObjectGroup<R, D extends Dashable<R>> {
        private final Class<? extends Dashable<?>> dashTag;
        private final Collection<DashObjectClass<R, D>> dashObjects;
        private final Set<Class<?>> dependencies;
        private boolean internalReferences = false;

        private DashObjectGroup(Class<? extends Dashable<?>> dashTag, Collection<DashObjectClass<R, D>> dashObjects, Set<Class<?>> dependencies) {
            this.dashTag = dashTag;
            this.dashObjects = dashObjects;
            this.dependencies = dependencies;
        }

        public DashObjectGroup(Class<? extends Dashable<?>> dashTag) {
            this(dashTag, new ArrayList<DashObjectClass<R, D>>(), new HashSet());
        }

        public void addDashObject(DashObjectClass<R, D> dashObject) {
            this.dashObjects.add(dashObject);
            this.dependencies.addAll(dashObject.getDependencies());
        }

        public void prepareForSort(Map<Class<?>, DashObjectGroup<R, D>> groups) {
            for (DashObjectClass<R, D> dashObjectClass : this.dashObjects) {
                this.internalReferences |= this.dependencies.remove(dashObjectClass.getDashClass());
            }
            for (DashObjectGroup dashObjectGroup : groups.values()) {
                for (DashObjectClass<R, D> dashObject : dashObjectGroup.dashObjects) {
                    Class<D> dashClass = dashObject.getDashClass();
                    if (!this.dependencies.contains(dashClass)) continue;
                    this.dependencies.remove(dashClass);
                    this.dependencies.add(dashObject.getTag());
                }
            }
        }

        public AbstractWriteChunk<R, D> createWriteChunk(byte pos, RegistryWriter writer, Map<Class<?>, DashFactory.FailCallback<?, ?>> callbacks) {
            DashFactory.FailCallback<Object, Dashable> callback = callbacks.getOrDefault(this.dashTag, (raw, writer1) -> {
                throw new RuntimeException("Cannot create " + raw);
            });
            DashFactory<Object, Dashable> factory = DashFactory.create(this.dashObjects, callback);
            String name = this.dashTag.getSimpleName();
            if (this.internalReferences) {
                HashSet<Class<D>> internalClasses = new HashSet<Class<D>>();
                for (DashObjectClass<R, D> dashObjectClass : this.dashObjects) {
                    internalClasses.add(dashObjectClass.getDashClass());
                }
                HashMap<DashObjectClass, List> internalDependencies = new HashMap<DashObjectClass, List>();
                for (DashObjectClass<R, D> dashObjectClass : this.dashObjects) {
                    for (Class<?> dependency : dashObjectClass.getDependencies()) {
                        if (!internalClasses.contains(dependency)) continue;
                        internalDependencies.computeIfAbsent(dashObjectClass, c -> new ArrayList()).add(dependency);
                    }
                }
                List list = RegistryHandler.calculateBuildOrder(Holder.map(this.dashObjects, obj -> new Holder<DashObjectClass>(obj.getDashClass(), internalDependencies.getOrDefault(obj, List.of()), (DashObjectClass)obj)));
                return new StagedWriteChunk<Object, Dashable>(pos, name, writer, list, factory);
            }
            if (this.dependencies.size() == 0) {
                return new FloatingWriteChunk<Object, Dashable>(pos, name, writer, this.dashObjects, factory);
            }
            return new WriteChunk<Object, Dashable>(pos, name, writer, this.dashObjects, factory);
        }
    }
}

